%%  ջ
warning off             % رձϢ
close all               % رտͼ
clear                   % ձ
clc                     % 

%%  
res = xlsread('ݼ.xlsx');

%%  ·
addpath('goat\')

%%  ѵͲԼ
temp = randperm(103);

P_train = res(temp(1: 80), 1: 7)';
T_train = res(temp(1: 80), 8)';
M = size(P_train, 2);

P_test = res(temp(81: end), 1: 7)';
T_test = res(temp(81: end), 8)';
N = size(P_test, 2);

%%  ݹһ
[p_train, ps_input] = mapminmax(P_train, 0, 1);
p_test = mapminmax('apply', P_test, ps_input);

[t_train, ps_output] = mapminmax(T_train, 0, 1);
t_test = mapminmax('apply', T_test, ps_output);

%%  ģ
S1 = 5;           %  زڵ                
net = newff(p_train, t_train, S1);

%%  ò
net.trainParam.epochs = 1000;        %  
net.trainParam.goal   = 1e-6;        % ֵ
net.trainParam.lr     = 0.01;        % ѧϰ

%%  Ż
gen = 50;                       % Ŵ
pop_num = 5;                    % Ⱥģ
S = size(p_train, 1) * S1 + S1 * size(t_train, 1) + S1 + size(t_train, 1);
                                % Ż
bounds = ones(S, 1) * [-1, 1];  % Ż߽

%%  ʼȺ
prec = [1e-6, 1];               % epslin Ϊ1e-6, ʵ
normGeomSelect = 0.09;          % ѡĲ
arithXover = 2;                 % 溯Ĳ
nonUnifMutation = [2 gen 3];    % 캯Ĳ

initPpp = initializega(pop_num, bounds, 'gabpEval', [], prec);  

%%  Ż㷨
[Bestpop, endPop, bPop, trace] = ga(bounds, 'gabpEval', [], initPpp, [prec, 0], 'maxGenTerm', gen,...
                           'normGeomSelect', normGeomSelect, 'arithXover', arithXover, ...
                           'nonUnifMutation', nonUnifMutation);

%%  ȡŲ
[val, W1, B1, W2, B2] = gadecod(Bestpop);

%%  ֵ
net.IW{1, 1} = W1;
net.LW{2, 1} = W2;
net.b{1}     = B1;
net.b{2}     = B2;

%%  ģѵ
net.trainParam.showWindow = 1;       % ѵ
net = train(net, p_train, t_train);  % ѵģ

%%  
t_sim1 = sim(net, p_train);
t_sim2 = sim(net, p_test );

%%  ݷһ
T_sim1 = mapminmax('reverse', t_sim1, ps_output);
T_sim2 = mapminmax('reverse', t_sim2, ps_output);

%%  
error1 = sqrt(sum((T_sim1 - T_train).^2) ./ M);
error2 = sqrt(sum((T_sim2 - T_test ).^2) ./ N);

%%  Ż
figure
plot(trace(:, 1), 1 ./ trace(:, 2), 'LineWidth', 1.5);
xlabel('');
ylabel('Ӧֵ');
string = {'Ӧȱ仯'};
title(string)
grid on

%%  ͼ
figure
plot(1: M, T_train, 'r-*', 1: M, T_sim1, 'b-o', 'LineWidth', 1)
legend('ʵֵ', 'Ԥֵ')
xlabel('Ԥ')
ylabel('Ԥ')
string = {'ѵԤԱ'; ['RMSE=' num2str(error1)]};
title(string)
xlim([1, M])
grid

figure
plot(1: N, T_test, 'r-*', 1: N, T_sim2, 'b-o', 'LineWidth', 1)
legend('ʵֵ', 'Ԥֵ')
xlabel('Ԥ')
ylabel('Ԥ')
string = {'ԼԤԱ'; ['RMSE=' num2str(error2)]};
title(string)
xlim([1, N])
grid

%%  ָ
%  R2
R1 = 1 - norm(T_train - T_sim1)^2 / norm(T_train - mean(T_train))^2;
R2 = 1 - norm(T_test  - T_sim2)^2 / norm(T_test  - mean(T_test ))^2;

disp(['ѵݵR2Ϊ', num2str(R1)])
disp(['ԼݵR2Ϊ', num2str(R2)])

%  MAE
mae1 = sum(abs(T_sim1 - T_train)) ./ M ;
mae2 = sum(abs(T_sim2 - T_test )) ./ N ;

disp(['ѵݵMAEΪ', num2str(mae1)])
disp(['ԼݵMAEΪ', num2str(mae2)])

%  MBE
mbe1 = sum(T_sim1 - T_train) ./ M ;
mbe2 = sum(T_sim2 - T_test ) ./ N ;

disp(['ѵݵMBEΪ', num2str(mbe1)])
disp(['ԼݵMBEΪ', num2str(mbe2)])

%  RMSE
disp(['ѵݵRMSEΪ', num2str(error1)])
disp(['ԼݵRMSEΪ', num2str(error2)])

%%  ɢͼ
sz = 25;
c = 'b';

figure
scatter(T_train, T_sim1, sz, c)
hold on
plot(xlim, ylim, '--k')
xlabel('ѵʵֵ');
ylabel('ѵԤֵ');
xlim([min(T_train) max(T_train)])
ylim([min(T_sim1) max(T_sim1)])
title('ѵԤֵ vs. ѵʵֵ')

figure
scatter(T_test, T_sim2, sz, c)
hold on
plot(xlim, ylim, '--k')
xlabel('Լʵֵ');
ylabel('ԼԤֵ');
xlim([min(T_test) max(T_test)])
ylim([min(T_sim2) max(T_sim2)])
title('ԼԤֵ vs. Լʵֵ')